import nltk
from nltk.probability import FreqDist
from nucular import Nucular

SIMPLE_ARCHIVE = 'c:/users/vaidhy/Development/scipy/archive/simple'

def getResults(w):
    archive = Nucular.Nucular(SIMPLE_ARCHIVE)
    q = archive.Query()
    q.anyWord(w)
    results = q.resultDictionaries()[0]
    return results

def doPOSTag(w):
    results = getResults(w)
    sentences = nltk.sent_tokenize(results['content'])
    tokenized_sentences = [nltk.word_tokenize(sentence) for sentence in sentences[:2]]
    tagged_sentences = [nltk.pos_tag(sentence) for sentence in tokenized_sentences]
    print "Sentences : " + str(sentences[:2])
    for tag_sentence in tagged_sentences:
        for tup in tag_sentence:
            print tup[0], tup[1]
        print
        
        
if __name__ == "__main__":   
    doPOSTag('parseltongue')
